<?php

require_once 'SerialNumberValidator.php';

/**
 * Usage: array('nip_field', 'ext.Validators.NipValidator')
 */
class NipValidator extends SerialNumberValidator
{
	/**
	 * none - 1234567819
	 * business - firma 123-45-67-819
	 * natural - osoba fizyczna 123-456-78-19
	 * @var string
	 */
	public $pattern = 'none';

	/**
	 * Wagi cyfr
	 * @var array
	 */
	public $weights = array(6, 5, 7, 2, 3, 4, 5, 6, 7);

	/**
	 * checksum modulo
	 * @var type
	 */
	public $modulo = 11;

	/**
	 * @param CModel $object
	 * @param string $attribute
	 */
	protected function validateAttribute($object, $attribute)
	{
		$value = trim($object->$attribute);

		if (empty($value)) return;

		switch ($this->pattern)
		{
			case 'business':
				if (!preg_match('/^[0-9]{3}-[0-9]{2}-[0-9]{2}-[0-9]{3}$/', $value))
				{
					$this->addError($object, $attribute, Yii::t('SerialNumberValidator','Pole attribute niespełnia wzorca pattern.'), array(
						'attribute' => $object->getAttributeLabel($attribute),
						'pattern' => '999-99-99-999'
					));
					return;
				}
				$value = str_replace('-', '', $value);
				break;
			case 'natural':
				if (!preg_match('/^[0-9]{3}-[0-9]{3}-[0-9]{2}-[0-9]{2}$/', $value))
				{
					$this->addError($object, $attribute, Yii::t('SerialNumberValidator','Pole attribute niespełnia wzorca pattern.'), array(
						'attribute' => $object->getAttributeLabel($attribute),
						'pattern' => '999-999-99-99'
					));
					return;
				}
				$value = str_replace('-', '', $value);
				break;
		}

		$this->validateCs($value, $object, $attribute);
	}
}
